/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class WindowController
extends WindowAdapter {
    private JFrame oldGUI;
    private JFrame currentGUI;

    protected void reset() {
    }

    protected JFrame getGui() {
        return this.currentGUI;
    }

    protected void destroy() {
        this.currentGUI.dispose();
        this.currentGUI = null;
    }

    public void setGui(JFrame newGUI) {
        this.oldGUI = this.currentGUI;
        if (this.oldGUI != null) {
            this.oldGUI.hide();
        }
        this.currentGUI = newGUI;
        this.currentGUI.setDefaultCloseOperation(0);
        this.currentGUI.addWindowListener(this);
        this.currentGUI.setResizable(false);
        this.currentGUI.setLocationRelativeTo(null);
        this.currentGUI.show();
    }

    public void previousGui() {
        this.currentGUI.hide();
        this.currentGUI.dispose();
        this.currentGUI = this.oldGUI;
        this.currentGUI.show();
        this.oldGUI = null;
    }

    public void quit() {
        int toQuit = JOptionPane.showConfirmDialog(null, "Do you really want to quit?", "", 0);
        if (toQuit == 0) {
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent e) {
        if (this.oldGUI == null) {
            this.quit();
        } else {
            this.reset();
        }
    }
}

