/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class StartGUI
extends JFrame {
    private String gameType;
    private Controller controller;

    public void setGameType(String ntype) {
        this.gameType = ntype;
    }

    private JPanel bottomPanel() {
        JPanel bp = new JPanel(new BorderLayout());
        bp.add((Component)this.leftPanel(), "West");
        bp.add((Component)this.networkPanel(), "East");
        return bp;
    }

    private JPanel leftPanel() {
        JPanel lp = new JPanel(new BorderLayout());
        lp.add((Component)this.singlePanel(), "Center");
        JButton quitButton = new JButton("Quit");
        quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartGUI.this.controller.quit();
            }
        });
        lp.add((Component)quitButton, "South");
        return lp;
    }

    private JPanel singlePanel() {
        JPanel sp = new JPanel(new GridLayout(2, 0));
        sp.setBorder(BorderFactory.createTitledBorder("Single Player"));
        JButton newGameButton = new JButton("New Game");
        newGameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartGUI.this.controller.newSinglePlayerGame();
            }
        });
        sp.add(newGameButton);
        JButton loadGameButton = new JButton("Load Game");
        loadGameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartGUI.this.controller.loadSinglePlayerGame();
            }
        });
        sp.add(loadGameButton);
        return sp;
    }

    private JPanel networkPanel() {
        JPanel np = new JPanel(new GridLayout(3, 0));
        np.setBorder(BorderFactory.createTitledBorder("Network"));
        JButton hostNewButton = new JButton("Host new game");
        hostNewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartGUI.this.controller.hostNewGame();
            }
        });
        np.add(hostNewButton);
        JButton connectButton = new JButton("Connect..");
        connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartGUI.this.controller.connectToGame();
            }
        });
        np.add(connectButton);
        JButton resumeHostButton = new JButton("Resume hosting");
        resumeHostButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartGUI.this.controller.resumeHostGame();
            }
        });
        np.add(resumeHostButton);
        return np;
    }

    public StartGUI(Controller c) {
        super("TrailBlazer Engine");
        this.controller = c;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new LogoPanel(), "Center");
        this.getContentPane().add((Component)this.bottomPanel(), "South");
        this.setSize(270, 270);
        c.setGui(this);
    }

    public static void main(String[] args) {
        new StartGUI(new Controller());
    }
}

