/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class RiverTravelPanel
extends JPanel {
    private ImageIcon river = new ImageIcon(this.getClass().getResource("/img/rivermilestone.png"));
    private boolean animating = false;
    private GameRunner gc;

    public boolean getAnimating() {
        return this.animating;
    }

    public RiverTravelPanel(GameRunner gr) {
        this.gc = gr;
        this.setPreferredSize(new Dimension(550, 450));
    }

    public void paintComponent(Graphics g) {
        if (!this.animating) {
            super.paintComponent(g);
            this.river.paintIcon(this, g, 0, 0);
            g.setColor(Color.black);
            g.fillRect(0, 420, 550, 450);
            g.setColor(Color.white);
            g.drawString("Welcome to the " + this.gc.getPlayerData().getNextMilestone().getName(), 5, 432);
        }
    }

    public void travel() {
        Object[] possibleValues = new Object[]{"Ford", "Caulk", "Ferry", "Wait"};
        Object value = "Test";
        String choices = "Wait";
        int depth = 0;
        this.repaint();
        this.validate();
        String n = this.gc.getPlayerData().getNextMilestone().getName().toLowerCase();
        if (-1 < n.indexOf("kansas")) {
            depth = (int)(Math.random() * 8.0) + 3;
            choices = "The Kansas River is " + depth + " feet deep.  A ferry costs 5 dollars.";
        } else if (-1 < n.indexOf("blue")) {
            depth = (int)(Math.random() * 4.0) + 2;
            possibleValues = new Object[]{"Ford", "Caulk", "Wait"};
            choices = "The Big Blue River is " + depth + " feet deep.";
        } else if (-1 < n.indexOf("green")) {
            depth = (int)(Math.random() * 8.0) + 5;
            choices = "The Green River is " + depth + " feet deep.  A ferry costs 5 dollars.";
        } else if (-1 < n.indexOf("snake")) {
            depth = (int)(Math.random() * 9.0) + 3;
            possibleValues = new Object[]{"Ford", "Caulk", "Hire a Native American", "Wait"};
            choices = "The Kansas River is " + depth + " feet deep.  A guide costs 5 sets of clothes.";
        }
        while ((value = JOptionPane.showInputDialog(null, choices, "Choose", 1, null, possibleValues, possibleValues[0])).equals("Ferry") && this.gc.getPlayerData().getPMoney() < 5.0 || value.equals("Hire a Native American") && this.gc.getPlayerData().getPClothes() < 5 || value == null) {
        }
        if (!value.equals("Wait")) {
            this.animating = true;
            this.setLayout(new BorderLayout());
            if (value.equals("Ford") && depth < 4) {
                this.add((Component)new CrossPanel(this.gc), "Center");
            } else if (value.equals("Ford") && depth >= 5) {
                this.add((Component)new CrossSinkPanel(this.gc), "Center");
            } else if (value.equals("Caulk") && (int)(Math.random() * 10.0) <= 1) {
                this.add((Component)new FordSinkPanel(this.gc), "Center");
            } else if (value.equals("Caulk")) {
                this.add((Component)new FordCrossPanel(this.gc), "Center");
            } else if (value.equals("Ferry")) {
                this.add((Component)new FordCrossPanel(this.gc), "Center");
                this.gc.getPlayerData().setPMoney(this.gc.getPlayerData().getPMoney() - 5.0);
            } else if (value.equals("Hire a Native American")) {
                this.add((Component)new FordCrossPanel(this.gc), "Center");
                this.gc.getPlayerData().setPClothes(this.gc.getPlayerData().getPClothes() - 5);
            }
        } else {
            this.gc.internalRestFor(1);
        }
        this.repaint();
        this.validate();
    }
}

