/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class RiverPanel
extends JPanel
implements ActionListener,
GameConstants,
RiverConstants {
    private RiverCrossing rc;
    private Timer riverTimer;

    public RiverCrossing getRC() {
        return this.rc;
    }

    public RiverPanel(GameRunner gr) {
        this.rc = new RiverCrossing(gr);
        this.riverTimer = new Timer(50, this);
        this.riverTimer.start();
        this.addKeyListener(this.rc);
    }

    public void actionPerformed(ActionEvent e) {
        this.rc.actionPerformed();
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.rc.getState() == 1) {
            this.paintRiver(g);
            this.paintRaft(g);
            this.paintRocks(g);
            this.paintSign(g);
        }
        if (this.rc.getState() == 0) {
            g.setColor(Color.black);
            g.fillRect(0, 0, 640, 480);
            g.setColor(Color.white);
            g.drawString("COLUMBIA RIVER CROSSING\n", 10, 100);
            g.drawString("Use 'A' to move the raft to the left\n", 10, 130);
            g.drawString("Use 'D' to move the raft to the right\n", 10, 160);
            g.drawString("Avoid sinking by navigating around rocks\n", 10, 190);
            g.drawString("You may bank your raft at any time by moving completely to either coastline\n", 10, 220);
            g.drawString("After you see your third direction sign, quickly move to the coast to land and avoid the oncoming waterfall\n", 10, 250);
            g.drawString("Act too slowly and your family  will plummet to their deaths\n", 10, 280);
        }
        if (this.rc.getState() == 3) {
            this.riverTimer.stop();
            this.paintRiver(g);
            this.paintRaft(g);
            this.paintRocks(g);
            this.paintSign(g);
            g.setColor(Color.white);
            g.drawString("You have banked your raft\n", 10, 100);
            g.drawString("One fourth of your supplies were lost, and only 1 oxen survived\n", 10, 115);
            g.drawString("Press the space bar to return to the game\n", 10, 130);
        }
        if (this.rc.getState() == 2) {
            this.riverTimer.stop();
            this.paintRiver(g);
            this.paintRaft(g);
            this.paintRocks(g);
            this.paintSign(g);
            g.setColor(Color.white);
            g.drawString("You have sunk your raft\n", 10, 100);
            g.drawString("One half of your supplies were lost, and only 1 oxen survived\n", 10, 115);
            g.drawString("Press the space bar to return to the game\n", 10, 120);
        }
        if (this.rc.getState() == 4) {
            g.setColor(Color.black);
            g.fillRect(0, 0, 640, 480);
            g.setColor(Color.white);
            g.drawString("Your family has fallen to its death\n", 10, 100);
            g.drawString("Press the space bar to return to the game\n", 10, 120);
        }
        if (this.rc.getState() == 5) {
            g.setColor(Color.black);
            g.fillRect(0, 0, 640, 480);
            g.setColor(Color.white);
            g.drawString("You successfully navigated the river\n", 10, 100);
            g.drawString("Press the space bar to return to the game\n", 10, 120);
        }
    }

    public void paintRiver(Graphics g) {
        ImageIcon riverIcon = new ImageIcon(this.getClass().getResource("/img/river.png"));
        riverIcon.paintIcon(this, g, 0, 0);
    }

    public void paintRaft(Graphics g) {
        int x = this.rc.getRiver().getPlayer().getX();
        int y = this.rc.getRiver().getPlayer().getY();
        ImageIcon raftIcon = new ImageIcon(this.getClass().getResource("/img/raft.png"));
        raftIcon.paintIcon(this, g, x, y);
    }

    public void paintRocks(Graphics g) {
        List rockList = this.rc.getRiver().getRockList();
        for (int i = 0; i < rockList.size(); ++i) {
            RiverRock temp = (RiverRock)rockList.get(i);
            ImageIcon rockIcon = new ImageIcon(this.getClass().getResource("/img/rock.png"));
            rockIcon.paintIcon(this, g, temp.getX(), temp.getY());
        }
    }

    public void paintSign(Graphics g) {
        int y;
        int x;
        if (this.rc.getRiver().getSign() != null) {
            x = this.rc.getRiver().getSign().getX();
            y = this.rc.getRiver().getSign().getY();
            ImageIcon signIcon = new ImageIcon(this.getClass().getResource("/img/sign.png"));
            signIcon.paintIcon(this, g, x, y);
        }
        if (this.rc.getCounter() > 1200) {
            x = this.rc.getRiver().getSign().getX() - 120;
            y = this.rc.getRiver().getSign().getY() + 60;
            ImageIcon pathIcon = new ImageIcon(this.getClass().getResource("/img/path.png"));
            pathIcon.paintIcon(this, g, x, y);
        }
    }

    public void poo() {
    }
}

