/*
 * Decompiled with CFR 0.152.
 */
import java.beans.DefaultPersistenceDelegate;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;

public class OUtils {
    static final int LOGLEVEL = 9;
    private static boolean pathsSetup = false;
    private static Map pDelMap = new Hashtable();

    private OUtils() {
    }

    static String objToString(Object obj) {
        if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            String ret = "Array[";
            if (0 < arr.length) {
                ret = ret + OUtils.objToString(arr[0].toString());
                for (int i = 1; i < arr.length; ++i) {
                    ret = ret + ";" + OUtils.objToString(arr[i].toString());
                }
            }
            ret = ret + "]";
            return ret;
        }
        if (null == obj) {
            return null;
        }
        return obj.toString();
    }

    static void out(int level, String output) {
        if (level <= 9) {
            System.out.println(output);
        }
    }

    static void err(int level, String output) {
        if (level <= 9) {
            System.err.println(output);
        }
    }

    public static void dp(String string) {
    }

    static void setupPaths() {
        if (pathsSetup) {
            return;
        }
        pathsSetup = true;
        String[] origPaths = Introspector.getBeanInfoSearchPath();
        HashSet<String> paths = new HashSet<String>(Arrays.asList(origPaths));
        paths.add("obeaninfos");
        Introspector.setBeanInfoSearchPath(paths.toArray(new String[0]));
    }

    public static void setPersistConstructor(String[] constructorPropertyNames) {
        Class<?> type;
        String typeName = new Throwable().getStackTrace()[1].getClassName();
        try {
            type = Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        pDelMap.put(type, new DefaultPersistenceDelegate(constructorPropertyNames));
    }

    static void setupPDs(XMLEncoder xe) {
        Class[] types = pDelMap.keySet().toArray(new Class[0]);
        for (int i = 0; i < types.length; ++i) {
            OUtils.out(700, "setting for " + types[i]);
            xe.setPersistenceDelegate(types[i], (PersistenceDelegate)pDelMap.get(types[i]));
        }
    }

    static void objToXML(Object obj, OutputStream os) throws IOException {
        OUtils.setupPaths();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder xe = new XMLEncoder(baos);
        OUtils.setupPDs(xe);
        xe.writeObject(obj);
        xe.close();
        OUtils.out(500, "XML about to send: <<\n" + baos.toString() + "\n>>");
        baos.writeTo(os);
    }

    static Object xmlToObj(InputStream is) throws IOException {
        int numBytesRead;
        byte[] bytes = new byte[2048];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OUtils.dp("before loop.");
        while (-1 != (numBytesRead = is.read(bytes))) {
            OUtils.dp("in loop.");
            baos.write(bytes, 0, numBytesRead);
        }
        OUtils.dp("after loop.");
        OUtils.out(500, "XML recieved: <<\n" + baos.toString() + "\n>>");
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        OUtils.dp("now in a bais.");
        OUtils.dp("before new XMLDecoder");
        XMLDecoder xd = new XMLDecoder(bais);
        OUtils.dp("after new XMLDecoder");
        Object o = xd.readObject();
        OUtils.dp("after readObject");
        return o;
    }
}

