/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ONetServer
extends ONet
implements Runnable {
    private OServer server;
    private ServerSocket serverSocket;
    private Socket cSock;
    private int port;
    private Messager msgr;

    ONetServer(int portParam, OServer serverParam, Messager msgrParam) throws IOException {
        this.server = serverParam;
        this.msgr = msgrParam;
        this.serverSocket = new ServerSocket(portParam);
        this.port = this.serverSocket.getLocalPort();
    }

    ONetServer(int portParam, OServer serverParam) throws IOException {
        this(portParam, serverParam, Messager.STD);
    }

    ONetServer(OServer serverParam) throws IOException {
        this(0, serverParam);
    }

    void useStreams() throws IOException {
        Object response;
        Object objRecvd = this.recv();
        if (!(objRecvd instanceof OServerAction)) {
            OUtils.err(5, "Can't cast object recieved to an OServerAction. object.getClass().getName()=" + objRecvd + ". objRecvd.toString()=" + objRecvd);
            return;
        }
        OServerAction osa = (OServerAction)objRecvd;
        try {
            response = this.server.handleRequest(osa, this.cSock);
        }
        catch (ORemoteException e) {
            response = e;
        }
        this.send(response);
    }

    public int getPort() {
        return this.port;
    }

    public void acceptForever() throws IOException {
        while (true) {
            OUtils.out(20, "");
            OUtils.out(20, "About to accept next connection...");
            this.cSock = this.serverSocket.accept();
            OUtils.out(20, "Accepted connection from " + this.cSock);
            this.useSocket(this.cSock);
            this.cSock.close();
            OUtils.out(20, "Closed connection (from " + this.cSock + ")");
        }
    }

    public void run() {
        try {
            this.acceptForever();
        }
        catch (IOException e) {
            OUtils.err(1, "Error: Died while serving my country.");
            e.printStackTrace();
        }
        try {
            if (null != this.serverSocket) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            OUtils.err(50, "Can't even close the server socket without errors.");
            e.printStackTrace();
        }
    }

    void destory() {
        try {
            if (null != this.serverSocket) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            OUtils.err(50, "Can't even close the server socket without errors.");
            e.printStackTrace();
        }
    }
}

