/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class MovingPanel
extends JPanel {
    private ImageIcon cart1 = new ImageIcon(this.getClass().getResource("/img/cart1.png"));
    private ImageIcon cart2 = new ImageIcon(this.getClass().getResource("/img/cart2.png"));
    private ImageIcon river = new ImageIcon(this.getClass().getResource("/img/mainriver.png"));
    private ImageIcon fort = new ImageIcon(this.getClass().getResource("/img/mainfort.png"));
    private ImageIcon rock = new ImageIcon(this.getClass().getResource("/img/mainmountain.png"));
    private ImageIcon other = new ImageIcon(this.getClass().getResource("/img/mainother.png"));
    private ImageIcon background = new ImageIcon(this.getClass().getResource("/img/background.png"));
    private int counter;
    private GameRunner gc;

    public MovingPanel(GameRunner gr) {
        this.gc = gr;
        this.counter = 0;
        this.setPreferredSize(new Dimension(550, 450));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int distance = this.gc.getPlayerData().getMilesLeftTillNextMilestone();
        ++this.counter;
        this.background.paintIcon(this, g, 0, 0);
        if (this.counter % 2 == 0) {
            this.cart1.paintIcon(this, g, 360, 322);
        } else {
            this.cart2.paintIcon(this, g, 360, 322);
        }
        if (distance <= 36) {
            switch (this.nextMilestone()) {
                case 0: {
                    this.river.paintIcon(this, g, 360 - distance * 10 - this.river.getIconWidth(), 320);
                    break;
                }
                case 1: {
                    this.fort.paintIcon(this, g, 360 - distance * 10 - this.fort.getIconWidth(), 322 - this.fort.getIconHeight());
                    break;
                }
                case 2: {
                    this.rock.paintIcon(this, g, 360 - distance * 10 - this.rock.getIconWidth(), 322 - this.rock.getIconHeight());
                    break;
                }
                case 3: {
                    this.other.paintIcon(this, g, 360 - distance * 10 - this.other.getIconWidth(), 320);
                    break;
                }
            }
        }
    }

    public int nextMilestone() {
        String lname = this.gc.getPlayerData().getNextMilestone().getName().toLowerCase();
        if (-1 < lname.indexOf("river")) {
            return 0;
        }
        if (-1 < lname.indexOf("fort")) {
            return 1;
        }
        if (-1 < lname.indexOf("rock") || -1 < lname.indexOf("mountain")) {
            return 2;
        }
        return 3;
    }
}

