/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class HuntingPanel
extends JPanel
implements ActionListener,
GameConstants,
HuntingConstants {
    private Hunting h;
    private Timer huntingTimer;
    private ImageIcon hunterL1 = new ImageIcon(this.getClass().getResource("/img/hunterL1.png"));
    private ImageIcon hunterR1 = new ImageIcon(this.getClass().getResource("/img/hunterR1.png"));
    private ImageIcon hunterU1 = new ImageIcon(this.getClass().getResource("/img/hunterU1.png"));
    private ImageIcon hunterS1 = new ImageIcon(this.getClass().getResource("/img/hunterD1.png"));
    private ImageIcon forest = new ImageIcon(this.getClass().getResource("/img/huntingForest.png"));
    private ImageIcon bearL1 = new ImageIcon(this.getClass().getResource("/img/bearL1.png"));
    private ImageIcon bearR1 = new ImageIcon(this.getClass().getResource("/img/bearR1.png"));
    private ImageIcon bearL2 = new ImageIcon(this.getClass().getResource("/img/bearL2.png"));
    private ImageIcon bearR2 = new ImageIcon(this.getClass().getResource("/img/bearR2.png"));
    private ImageIcon bearLD = new ImageIcon(this.getClass().getResource("/img/bearLD.png"));
    private ImageIcon bearRD = new ImageIcon(this.getClass().getResource("/img/bearRD.png"));
    private ImageIcon buffaloL1 = new ImageIcon(this.getClass().getResource("/img/buffaloL1.png"));
    private ImageIcon buffaloR1 = new ImageIcon(this.getClass().getResource("/img/buffaloR1.png"));
    private ImageIcon buffaloL2 = new ImageIcon(this.getClass().getResource("/img/buffaloL2.png"));
    private ImageIcon buffaloR2 = new ImageIcon(this.getClass().getResource("/img/buffaloR2.png"));
    private ImageIcon buffaloLD = new ImageIcon(this.getClass().getResource("/img/buffaloLD.png"));
    private ImageIcon buffaloRD = new ImageIcon(this.getClass().getResource("/img/buffaloRD.png"));
    private ImageIcon rabbitL1 = new ImageIcon(this.getClass().getResource("/img/rabbitL1.png"));
    private ImageIcon rabbitR1 = new ImageIcon(this.getClass().getResource("/img/rabbitR1.png"));
    private ImageIcon rabbitL2 = new ImageIcon(this.getClass().getResource("/img/rabbitL2.png"));
    private ImageIcon rabbitR2 = new ImageIcon(this.getClass().getResource("/img/rabbitR2.png"));
    private ImageIcon rabbitLD = new ImageIcon(this.getClass().getResource("/img/rabbitLD.png"));
    private ImageIcon rabbitRD = new ImageIcon(this.getClass().getResource("/img/rabbitRD.png"));
    private ImageIcon squirrelL1 = new ImageIcon(this.getClass().getResource("/img/squirrelL1.png"));
    private ImageIcon squirrelR1 = new ImageIcon(this.getClass().getResource("/img/squirrelR1.png"));
    private ImageIcon squirrelL2 = new ImageIcon(this.getClass().getResource("/img/squirrelL2.png"));
    private ImageIcon squirrelR2 = new ImageIcon(this.getClass().getResource("/img/squirrelR2.png"));
    private ImageIcon squirrelLD = new ImageIcon(this.getClass().getResource("/img/squirrelLD.png"));
    private ImageIcon squirrelRD = new ImageIcon(this.getClass().getResource("/img/squirrelRD.png"));
    private ImageIcon deerL1 = new ImageIcon(this.getClass().getResource("/img/deerL1.png"));
    private ImageIcon deerR1 = new ImageIcon(this.getClass().getResource("/img/deerR1.png"));
    private ImageIcon deerL2 = new ImageIcon(this.getClass().getResource("/img/deerL2.png"));
    private ImageIcon deerR2 = new ImageIcon(this.getClass().getResource("/img/deerR2.png"));
    private ImageIcon deerLD = new ImageIcon(this.getClass().getResource("/img/deerLD.png"));
    private ImageIcon deerRD = new ImageIcon(this.getClass().getResource("/img/deerRD.png"));

    public void actionPerformed(ActionEvent e) {
        this.h.actionPerformed();
        this.repaint();
    }

    public Hunting getH() {
        return this.h;
    }

    public HuntingPanel(GameRunner gr) {
        this.h = new Hunting(gr);
        this.huntingTimer = new Timer(50, this);
        this.huntingTimer.start();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.h.getState() == 1) {
            this.forest.paintIcon(this, g, 0, 0);
            this.paintTerrain(g);
            this.paintHunter(g);
            this.paintAnimals(g);
        } else {
            this.paintCompletion(g);
        }
    }

    public void paintCompletion(Graphics g) {
        int meat = this.h.getMeat();
        g.setColor(Color.black);
        g.fillRect(0, 0, 640, 480);
        g.setColor(Color.white);
        g.drawString("You collected " + meat + " pounds of meat\n", 10, 100);
        if (meat > 100) {
            g.drawString("but you can only carry 100 pounds back.\n", 10, 120);
        }
        g.drawString("Press \"O\" to return to the Oregon Trail\n", 10, 140);
    }

    public void paintHunter(Graphics g) {
        int x = this.h.getHG().getPlayer().getX();
        int y = this.h.getHG().getPlayer().getY();
        int dir = this.h.getHG().getPlayer().getDirection();
        if (this.h.getHG().getBullet() != null) {
            g.setColor(Color.white);
            g.fillOval(this.h.getHG().getBullet().getX(), this.h.getHG().getBullet().getY(), 1, 1);
        }
        switch (dir) {
            case 2: {
                this.hunterL1.paintIcon(this, g, x, y);
                break;
            }
            case 3: {
                this.hunterR1.paintIcon(this, g, x, y);
                break;
            }
            case 0: {
                this.hunterU1.paintIcon(this, g, x, y);
                break;
            }
            case 1: {
                this.hunterS1.paintIcon(this, g, x, y);
                break;
            }
        }
    }

    public void paintTerrain(Graphics g) {
        g.setColor(Color.green);
        for (int i = 0; i < this.h.getHG().getObstacles().size(); ++i) {
            Obstacle temp = (Obstacle)this.h.getHG().getObstacles().get(i);
            int x = temp.getX();
            int y = temp.getY();
            if (temp.getType() == 1) {
                ImageIcon treeIcon = new ImageIcon(this.getClass().getResource("/img/tree.png"));
                treeIcon.paintIcon(this, g, x, y);
                continue;
            }
            ImageIcon rockIcon = new ImageIcon(this.getClass().getResource("/img/forestRock.png"));
            rockIcon.paintIcon(this, g, x, y);
        }
    }

    public void paintAnimals(Graphics g) {
        int counter = this.h.getCounter();
        List animals = this.h.getHG().getAnimals();
        g.setColor(Color.blue);
        for (int i = 0; i < animals.size(); ++i) {
            HuntAnimal temp = (HuntAnimal)animals.get(i);
            if (temp.getType() == 0) {
                switch (temp.getDirection()) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: {
                        if (temp.getIsDead()) {
                            this.bearLD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 10 > 5) {
                            this.bearL1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.bearL2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                    default: {
                        if (temp.getIsDead()) {
                            this.bearRD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 10 > 5) {
                            this.bearR1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.bearR2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                }
                continue;
            }
            if (temp.getType() == 1) {
                switch (temp.getDirection()) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: {
                        if (temp.getIsDead()) {
                            this.rabbitLD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 8 > 4) {
                            this.rabbitL1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.rabbitL2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                    default: {
                        if (temp.getIsDead()) {
                            this.rabbitRD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 8 > 4) {
                            this.rabbitR1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.rabbitR2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                }
                continue;
            }
            if (temp.getType() == 3) {
                switch (temp.getDirection()) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: {
                        if (temp.getIsDead()) {
                            this.squirrelLD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 8 > 4) {
                            this.squirrelL1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.squirrelL2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                    default: {
                        if (temp.getIsDead()) {
                            this.squirrelRD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 10 > 5) {
                            this.squirrelR1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.squirrelR2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                }
                continue;
            }
            if (temp.getType() == 2) {
                switch (temp.getDirection()) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: {
                        if (temp.getIsDead()) {
                            this.buffaloLD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 10 > 5) {
                            this.buffaloL1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.buffaloL2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                    default: {
                        if (temp.getIsDead()) {
                            this.buffaloRD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 10 > 5) {
                            this.buffaloR1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.buffaloR2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                }
                continue;
            }
            if (temp.getType() == 4) {
                switch (temp.getDirection()) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: {
                        if (temp.getIsDead()) {
                            this.deerLD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 10 > 5) {
                            this.deerL1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.deerL2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                    default: {
                        if (temp.getIsDead()) {
                            this.deerRD.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        if (counter % 10 > 5) {
                            this.deerR1.paintIcon(this, g, temp.getX(), temp.getY());
                            break;
                        }
                        this.deerR2.paintIcon(this, g, temp.getX(), temp.getY());
                        break;
                    }
                }
                continue;
            }
            g.fillRect(temp.getX(), temp.getY(), temp.getWidth(), temp.getHeight());
        }
    }

    public void poo() {
    }
}

