/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class HighScores {
    private static Comparator scoreComp = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ScoreRecord)o2).getScore() - ((ScoreRecord)o1).getScore();
        }
    };
    private String filePath = "HighScores.xml";
    private File file = new File(this.filePath);
    private List scores = this.readFromDisk();

    public List getTopTen() {
        Collections.sort(this.scores, scoreComp);
        return this.scores.subList(0, Math.min(this.scores.size(), 10));
    }

    public List readFromDisk() {
        ScoreRecord[] scoresFromFile;
        FileInputStream fis = null;
        if (this.file.exists()) {
            try {
                fis = new FileInputStream(this.filePath);
            }
            catch (FileNotFoundException e) {
                System.err.println("Error reading file: " + e);
            }
        }
        if (fis == null) {
            return new Vector();
        }
        try {
            scoresFromFile = (ScoreRecord[])OUtils.xmlToObj(fis);
        }
        catch (Exception e) {
            return new Vector();
        }
        Vector<ScoreRecord> scoreList = new Vector<ScoreRecord>();
        for (int i = 0; i < scoresFromFile.length; ++i) {
            scoreList.add(scoresFromFile[i]);
        }
        return scoreList;
    }

    public boolean addScore(String name, int score) {
        ScoreRecord sr = new ScoreRecord(name, score);
        this.scores.add(sr);
        this.scores = this.getTopTen();
        ScoreRecord[] scoresArray = this.scores.toArray(new ScoreRecord[0]);
        try {
            OUtils.objToXML(scoresArray, new FileOutputStream(this.file));
        }
        catch (Exception e) {
            System.err.println("error writing high scores file");
        }
        return this.scores.contains(sr);
    }
}

