/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GraphicsPanel
extends JPanel
implements ActionListener {
    private boolean moving;
    private GameRunner gc;
    private Timer t;
    private JPanel panel;

    public GraphicsPanel(GameRunner gr) {
        this.setLayout(new BorderLayout());
        this.gc = gr;
        this.moving = false;
        this.t = new Timer(500, this);
        this.t.start();
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.gc.getPlayerData().atAMilestone() && !(this.panel instanceof MovingPanel)) {
            if (this.panel != null) {
                this.remove(this.panel);
            }
            this.panel = new MovingPanel(this.gc);
            this.add((Component)this.panel, "Center");
        } else if (this.gc.getPlayerData().atAMilestone() && (this.panel == null || this.panel instanceof MovingPanel)) {
            String lname = this.gc.getPlayerData().getNextMilestone().getName().toLowerCase();
            if (this.gc.getPlayerData().atAMilestone()) {
                this.setUp(lname);
            }
        }
        this.repaint();
        this.validate();
        if (this.panel instanceof RiverTravelPanel && !((RiverTravelPanel)this.panel).getAnimating()) {
            ((RiverTravelPanel)this.panel).travel();
        }
    }

    public void setUp(String lname) {
        if (this.panel != null) {
            this.remove(this.panel);
        }
        if (-1 < lname.indexOf("river")) {
            this.panel = new RiverTravelPanel(this.gc);
            this.add((Component)this.panel, "Center");
            this.moving = false;
        } else if (-1 < lname.indexOf("fort")) {
            this.panel = new FortPanel(this.gc);
            this.add((Component)this.panel, "Center");
            this.moving = false;
        } else if (-1 < lname.indexOf("rock") || -1 < lname.indexOf("mountain")) {
            this.panel = new RockPanel(this.gc);
            this.add((Component)this.panel, "Center");
            this.moving = false;
        } else {
            this.panel = new OtherPanel(this.gc);
            this.add((Component)this.panel, "Center");
            this.moving = false;
        }
    }
}

