/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Map;

public class GameServer
extends OServer {
    private Messager msgr;
    private Map players = new Hashtable();
    private boolean gameStarted = false;
    private Controller controller;

    public GameServer(Messager msgrParam, Controller controllerParam) {
        this.msgr = msgrParam;
        this.controller = controllerParam;
    }

    public GameServer(Controller controllerParam) {
        this(Messager.STD, controllerParam);
    }

    public boolean addPlayer(String name, int portNum) {
        if (this.gameStarted) {
            return false;
        }
        InetAddress ia = this.getClientSocket().getInetAddress();
        this.players.put(name, new GameServerPlayerInfo(ia, portNum, name));
        this.controller.addPlayer(name, "" + ia);
        return true;
    }

    public void maybeSendOtherPlayerStats() {
        int i;
        GameServerPlayerInfo[] playerInfos = this.players.values().toArray(new GameServerPlayerInfo[0]);
        Hashtable<String, PlayerStats> pStatList = new Hashtable<String, PlayerStats>();
        for (i = 0; i < playerInfos.length; ++i) {
            if (null == playerInfos[i].getPlayerStats()) {
                return;
            }
            pStatList.put(playerInfos[i].getName(), playerInfos[i].getPlayerStats());
        }
        for (i = 0; i < playerInfos.length; ++i) {
            try {
                playerInfos[i].getONetClient().sendRequest(new AllPlayerStatsAction(pStatList));
                continue;
            }
            catch (Exception e) {
                this.msgr.sendError("Couldn't tell player game has started: " + e);
                e.printStackTrace();
            }
        }
        for (i = 0; i < playerInfos.length; ++i) {
            playerInfos[i].setPlayerStats(null);
        }
    }

    public void setPlayerStats(String playerName, PlayerStats playerStats) {
        ((GameServerPlayerInfo)this.players.get(playerName)).setPlayerStats(playerStats);
        new Thread(){

            public void run() {
                GameServer.this.maybeSendOtherPlayerStats();
            }
        }.start();
    }

    void startGame(StaticGameData sd, DynamicData dd) {
        this.gameStarted = true;
        GameServerPlayerInfo[] playerInfos = this.players.values().toArray(new GameServerPlayerInfo[0]);
        for (int i = 0; i < playerInfos.length; ++i) {
            try {
                playerInfos[i].getONetClient().sendRequest(new GameStartedAction(sd, dd, ""));
                continue;
            }
            catch (Exception e) {
                this.msgr.sendError("Couldn't tell player game has started: " + e);
                e.printStackTrace();
            }
        }
    }
}

