/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class GameRunner
extends WindowController {
    private GameGUI gui;
    private DynamicData ddata;
    private StaticGameData sdata;
    private EventDriver ed;
    private String playerName;
    private ServerConnection sc;
    private int restDays;

    public String getPlayerName() {
        return this.playerName;
    }

    protected void goShooting() {
        this.setGui(new HuntingFrame(this));
    }

    protected void demoRiver() {
        this.goRiding();
    }

    protected void goRiding() {
        this.setGui(new RiverFrame(this));
    }

    protected void rest() {
        this.setGui(new ChooseRestTime(this));
    }

    protected void trade() {
        if (this.getPlayerData().atAFort()) {
            this.setGui(new TradeGUI(this, false));
        } else {
            Random randomizer = new Random();
            int item1 = randomizer.nextInt(6);
            int item2 = randomizer.nextInt(6);
            int numitem1 = randomizer.nextInt(8) + 1;
            int numitem2 = randomizer.nextInt(8) + 1;
            String[] choices = new String[]{"bullets", "pound(s) of food", "piece(s) of clothing", "wagon wheel(s)", "wagon axel(s)", "wagon tongue(s)", "ox(en)"};
            int choice = JOptionPane.showConfirmDialog(this.getGui(), "Would you like to trade " + numitem1 + " of your " + choices[item1] + " to an indian for " + numitem2 + " of " + choices[item2] + "?", "Accept Trade?", 0);
            if (choice == 0) {
                boolean success = false;
                switch (item1) {
                    case 0: {
                        if (this.getPlayerData().getPAmmo() < numitem1) break;
                        success = true;
                        this.getPlayerData().setPAmmo(this.getPlayerData().getPAmmo() - numitem1);
                        break;
                    }
                    case 1: {
                        if (this.getPlayerData().getPFood() < numitem1) break;
                        success = true;
                        this.getPlayerData().setPFood(this.getPlayerData().getPFood() - numitem1);
                        break;
                    }
                    case 2: {
                        if (this.getPlayerData().getPClothes() < numitem1) break;
                        success = true;
                        this.getPlayerData().setPClothes(this.getPlayerData().getPClothes() - numitem1);
                        break;
                    }
                    case 3: {
                        if (this.getPlayerData().getPPart1() < numitem1) break;
                        success = true;
                        this.getPlayerData().setPPart1(this.getPlayerData().getPPart1() - numitem1);
                        break;
                    }
                    case 4: {
                        if (this.getPlayerData().getPPart2() < numitem1) break;
                        success = true;
                        this.getPlayerData().setPPart2(this.getPlayerData().getPPart2() - numitem1);
                        break;
                    }
                    case 5: {
                        if (this.getPlayerData().getPPart3() < numitem1) break;
                        success = true;
                        this.getPlayerData().setPPart3(this.getPlayerData().getPPart3() - numitem1);
                        break;
                    }
                    case 6: {
                        if (this.getPlayerData().getPMovers()[0] < numitem1) break;
                        success = true;
                        this.getPlayerData().addPMover();
                        break;
                    }
                }
                if (success) {
                    switch (item2) {
                        case 0: {
                            this.getPlayerData().setPAmmo(this.getPlayerData().getPAmmo() + numitem2);
                            break;
                        }
                        case 1: {
                            this.getPlayerData().setPFood(this.getPlayerData().getPFood() + numitem2);
                            break;
                        }
                        case 2: {
                            this.getPlayerData().setPClothes(this.getPlayerData().getPClothes() + numitem2);
                            break;
                        }
                        case 3: {
                            this.getPlayerData().setPPart1(this.getPlayerData().getPPart1() + numitem2);
                            break;
                        }
                        case 4: {
                            this.getPlayerData().setPPart2(this.getPlayerData().getPPart2() + numitem2);
                            break;
                        }
                        case 5: {
                            this.getPlayerData().setPPart3(this.getPlayerData().getPPart3() + numitem2);
                            break;
                        }
                        case 6: {
                            this.getPlayerData().removePMover();
                            break;
                        }
                    }
                    JOptionPane.showMessageDialog(this.getGui(), "The trade was successful!");
                } else {
                    JOptionPane.showMessageDialog(this.getGui(), "The trade was not successful because you tried to trade more than you have!");
                }
            }
            this.internalRestFor(1);
        }
    }

    protected void checkMap() {
        this.setGui(new BigMapFrame(this));
    }

    protected void checkSupplies() {
        this.setGui(new SupplyGUI(this));
    }

    protected void gameMenu() {
        this.setGui(new GameMenu(this));
    }

    protected void saveGame() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this.getGui());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            GameStartedAction objToSave = new GameStartedAction(this.sdata, this.ddata, this.playerName);
            try {
                OUtils.objToXML(objToSave, new FileOutputStream(file));
            }
            catch (FileNotFoundException fnfe) {
                Messager.STD.sendError("We can't use that file (" + file + "), try again.", fnfe);
                return;
            }
            catch (Exception e) {
                Messager.STD.sendError("Unable to save game.", e);
                return;
            }
            JOptionPane.showMessageDialog(this.getGui(), "Game Saved!");
        }
    }

    protected void showHighScores() {
        new HighScoreView();
    }

    protected void about() {
        new AboutView(this);
    }

    protected void setInitialData(String p0, String p1, String p2, String p3, String t) {
        this.getPlayerData().getPMember(0).setName(p0);
        this.getPlayerData().getPMember(1).setName(p1);
        this.getPlayerData().getPMember(2).setName(p2);
        this.getPlayerData().getPMember(3).setName(p3);
        this.getPlayerData().setPlayerType(t);
        if (t.equals("Farmer")) {
            this.getPlayerData().setPMoney(400.0);
        } else if (t.equals("Banker")) {
            this.getPlayerData().setPMoney(1600.0);
        } else if (t.equals("Carpenter")) {
            this.getPlayerData().setPMoney(800.0);
        }
        this.previousGui();
        this.setGui(new TradeGUI(this, true));
    }

    protected void setSpeed(String nSpeed) {
        this.getPlayerData().setPPace(nSpeed);
        this.gui.updateGUI();
    }

    protected void setRations(String nRations) {
        this.getPlayerData().setPRations(nRations);
        this.gui.updateGUI();
    }

    protected PlayerStats getPlayerData() {
        return (PlayerStats)this.ddata.getStatList().get(this.playerName);
    }

    protected StaticGameData getStaticData() {
        return this.sdata;
    }

    protected DynamicData getDynamicData() {
        return this.ddata;
    }

    public int calcTravelDistance(String pace, int oxen) {
        int paceMult = 1;
        int oxPower = 7;
        if (pace.equals("strenuous")) {
            paceMult = 2;
        } else if (pace.equals("grueling")) {
            paceMult = 3;
        }
        oxPower = oxen == 0 ? 0 : oxPower + oxen - 1;
        return paceMult * oxPower;
    }

    public void restFor(int nrestDays) {
        this.previousGui();
        this.internalRestFor(nrestDays);
    }

    public void internalRestFor(int nrestDays) {
        this.restDays = nrestDays;
        this.endTurn();
    }

    public void eat() {
        int numEaters = 5 - this.getPlayerData().getMemsDead();
        int toEat = this.getPlayerData().getPRations().equals("filling") ? numEaters * 3 : (this.getPlayerData().getPRations().equals("meager") ? numEaters * 2 : numEaters);
        if (toEat >= this.getPlayerData().getPFood() && (toEat = this.getPlayerData().getPFood()) > 0) {
            JOptionPane.showMessageDialog(null, "You are out of food.");
        }
        this.getPlayerData().setPFood(this.getPlayerData().getPFood() - toEat);
    }

    public void healer(Person toHeal) {
        Random decision = new Random();
        if (decision.nextInt(100) < 24) {
            toHeal.setSick(false);
            JOptionPane.showMessageDialog(null, toHeal.getName() + " got better.");
        }
    }

    public void killer(Person toKill) {
        Random decision = new Random();
        if (decision.nextDouble() < toKill.getDeathProb()) {
            toKill.setSick(false);
            toKill.setIsDead(true);
            JOptionPane.showMessageDialog(null, toKill.getName() + " has died.");
        } else if (toKill.getDeathProb() < 0.75) {
            toKill.setDeathProb(toKill.getDeathProb() + 0.05);
        }
    }

    public void oxHealer(int toHeal) {
        Random decision = new Random();
        if (decision.nextInt(100) < 24) {
            this.getPlayerData().getPMDying().remove(toHeal);
            int[] nArray = this.getPlayerData().getPMovers();
            nArray[1] = nArray[1] - 1;
            JOptionPane.showMessageDialog(null, "An ox got better.");
        }
    }

    public void oxKiller(int toKill) {
        Random decision = new Random();
        if (toKill >= this.getPlayerData().getPMDying().size()) {
            this.oxKiller(toKill - 1);
            return;
        }
        if (this.getPlayerData().getPMDying().size() == 0) {
            return;
        }
        Double toKillProb = (Double)this.getPlayerData().getPMDying().get(toKill);
        if (decision.nextDouble() < toKillProb) {
            this.getPlayerData().getPMDying().remove(toKill);
            int[] nArray = this.getPlayerData().getPMovers();
            nArray[1] = nArray[1] - 1;
            int[] nArray2 = this.getPlayerData().getPMovers();
            nArray2[0] = nArray2[0] - 1;
            JOptionPane.showMessageDialog(null, "An ox has died.");
        } else {
            this.getPlayerData().getPMDying().set(toKill, new Double(toKillProb + 0.05));
        }
    }

    protected void startTurn(Hashtable h) {
        int i;
        ((GameGUI)this.getGui()).setButtonsEnabled(true);
        this.ddata.getGameDate().roll(5, true);
        this.ddata.setTrailDays(this.ddata.getTrailDays() + 1);
        this.ddata.setStatList(h);
        int toTravel = this.calcTravelDistance(this.getPlayerData().getPPace(), this.getPlayerData().getPMovers()[0]);
        boolean resting = false;
        if (this.restDays > 0 || this.getPlayerData().getStuck()) {
            toTravel = 0;
            resting = true;
            JOptionPane.showMessageDialog(this.getGui(), "You sit around, resting yourself and your oxen.");
        }
        if (toTravel > 0 && this.getPlayerData().atAMilestone()) {
            int n = 0;
            NextMilestoneData[] milestones = this.getPlayerData().getNextMilestone().getNextMilestones();
            if (milestones != null) {
                Object[] options = new Object[milestones.length];
                for (int i2 = 0; i2 < milestones.length; ++i2) {
                    options[i2] = "To the " + milestones[i2].getMilestone().getName();
                }
                if (null != options && 1 < options.length) {
                    n = JOptionPane.showOptionDialog(this.getGui(), "Which path would you like to take?", "Choose your path", 0, 3, null, options, options[0]);
                }
                this.getPlayerData().setLastMilestone(this.getPlayerData().getNextMilestone());
                this.getPlayerData().setMilesInbetween(milestones[n].getDistance());
                this.getPlayerData().setMilesLeftTillNextMilestone(milestones[n].getDistance());
                this.getPlayerData().setNextMilestone(milestones[n].getMilestone());
            } else {
                this.endGame();
            }
        }
        if (!resting && toTravel == 0) {
            JOptionPane.showMessageDialog(this.getGui(), "You sit around, wondering what to do.");
        }
        while (toTravel > 0) {
            this.getPlayerData().decMilesLeftTillNextMilestone();
            --toTravel;
            this.getPlayerData().setTrailPos(this.getPlayerData().getTrailPos() + 1);
        }
        this.eat();
        if (this.getPlayerData().getPMovers()[1] > 0) {
            for (i = 0; i < this.getPlayerData().getPMovers()[1]; ++i) {
                if (resting) {
                    this.oxHealer(i);
                    continue;
                }
                this.oxKiller(i);
            }
        }
        for (i = 0; i < 4; ++i) {
            if (!this.getPlayerData().getPMembers()[i].getSick()) continue;
            if (resting) {
                this.healer(this.getPlayerData().getPMembers()[i]);
                continue;
            }
            this.killer(this.getPlayerData().getPMembers()[i]);
        }
        if (this.getPlayerData().getLeader().getSick()) {
            if (resting) {
                this.healer(this.getPlayerData().getLeader());
            } else {
                this.killer(this.getPlayerData().getLeader());
            }
        }
        if (!this.getPlayerData().atAMilestone()) {
            RandomEvent toRun = this.ed.chooseEvent();
            this.ed.runEvent(toRun, this.getPlayerData());
        }
        if (this.getGui() instanceof GameGUI) {
            ((GameGUI)this.getGui()).updateGUI();
        }
        if (this.restDays > 0) {
            --this.restDays;
            this.endTurn();
        }
    }

    protected void endTurn() {
        if (this.getGui() instanceof GameGUI) {
            ((GameGUI)this.getGui()).updateGUI();
        }
        try {
            this.sc.sendRequest(new PlayerStatsAction(this.sc, this.getPlayerData()));
        }
        catch (Exception e) {
            Messager.STD.sendError("Unable to send PlayerStats to GameServer.", e);
            return;
        }
        if (this.getGui() instanceof GameGUI) {
            ((GameGUI)this.getGui()).setButtonsEnabled(false);
        }
    }

    protected void endGame() {
        int totalPoints = this.tallyPoints();
        if (this.getPlayerData().getLeader().getIsDead()) {
            JOptionPane.showMessageDialog(this.getGui(), "Your party has died");
            System.exit(0);
        } else {
            JOptionPane.showMessageDialog(this.getGui(), "Congratulations " + this.playerName + "! You Made it to Oregon!\n" + "-your score is: " + totalPoints + "\n-your " + "party health is: " + this.partyHealth());
            if (new HighScores().addScore(this.playerName, totalPoints)) {
                JOptionPane.showMessageDialog(this.getGui(), "You made it to the top ten!");
            }
            JOptionPane.showMessageDialog(this.getGui(), "Thanks for playing Oregon Trail with the TrailBlazer game engine! Play again soon!");
            System.exit(0);
        }
    }

    public String partyHealth() {
        int healthLevel = 4;
        for (int i = 0; i < 4; ++i) {
            if (this.getPlayerData().getPMember(i).getHealth().equals("sick")) {
                --healthLevel;
                continue;
            }
            if (!this.getPlayerData().getPMember(i).getHealth().equals("dead")) continue;
            healthLevel -= 2;
        }
        if (this.getPlayerData().getPHealth().equals("sick")) {
            --healthLevel;
        }
        if (healthLevel < 0) {
            healthLevel = 0;
        }
        String[] levels = new String[]{"Very Poor", "Poor", "Fair", "Good", "Very Good"};
        return levels[healthLevel];
    }

    public int tallyPoints() {
        int points = 50;
        points += this.getPlayerData().getClothesCount() * 2;
        points += this.getPlayerData().getAmmoCount() / 25;
        points += this.getPlayerData().getFoodCount() / 25;
        points += this.getPlayerData().getpart1count() * 3;
        points += this.getPlayerData().getpart2count() * 3;
        points += this.getPlayerData().getpart3count() * 3;
        points += this.getPlayerData().getPMovers()[0] * 4;
        points = (int)((double)points + this.getPlayerData().getMoneyCount() / 5.0);
        String health = this.partyHealth();
        if (null != health) {
            if (health.equals("Very Poor")) {
                points += 200;
            } else if (health.equals("Poor")) {
                points += 300;
            } else if (health.equals("Fair")) {
                points += 400;
            } else if (health.equals("Good")) {
                points += 500;
            } else if (health.equals("Very Good")) {
                points += 600;
            }
        }
        if (this.getPlayerData().getPlayerType().equals("Farmer")) {
            points *= 3;
        } else if (this.getPlayerData().getPlayerType().equals("Carpenter")) {
            points *= 2;
        } else if (this.getPlayerData().getPlayerType().equals("Banker")) {
            points *= 1;
        }
        return points;
    }

    protected void reset() {
        if (!(this.getGui() instanceof RiverFrame || this.getGui() instanceof HuntingFrame || this.getGui() instanceof ChooseCharacterGUI)) {
            this.previousGui();
        }
    }

    public void previousGui() {
        if (this.getGui() instanceof GameGUI) {
            ((GameGUI)this.getGui()).updateGUI();
        }
        super.previousGui();
        if (this.getGui() instanceof GameGUI) {
            ((GameGUI)this.getGui()).updateGUI();
        }
    }

    public GameRunner(String name, StaticGameData sd, DynamicData dd, ServerConnection scParam) {
        this.playerName = name;
        this.ed = new EventDriver(this);
        this.sdata = sd;
        this.ddata = dd;
        this.sc = scParam;
        this.gui = new GameGUI(this);
        this.setGui(this.gui);
        this.gui.updateGUI();
        if (dd.getTrailDays() == 0) {
            this.setGui(new ChooseCharacterGUI(this));
        }
    }
}

