/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GameGUI
extends JFrame {
    private GameRunner runner;
    private JTextField tothingField;
    private JTextField toendField;
    private JTextField dateField;
    private JTextField daysField;
    private JTextField healthField;
    private JLabel name1Label;
    private JLabel name2Label;
    private JLabel name3Label;
    private JLabel name4Label;
    private JLabel nextThingLabel;
    private JTextField health1Field;
    private JTextField health2Field;
    private JTextField health3Field;
    private JTextField health4Field;
    private JLabel typeLabel;
    private String[] speeds = new String[]{"steady", "strenuous", "grueling"};
    private JComboBox speedCombo;
    private String[] rations = new String[]{"bare bones", "meager", "filling"};
    private JComboBox rationsCombo;
    private JButton tradeButton;
    private JButton huntButton;
    private JButton restButton;
    private JButton turndoneButton;
    private JButton mapButton;
    private JButton gamemenuButton;
    private JButton supplyButton;

    public void setButtonsEnabled(boolean b) {
        this.huntButton.setEnabled(b);
        this.tradeButton.setEnabled(b);
        this.restButton.setEnabled(b);
        this.turndoneButton.setEnabled(b);
        this.mapButton.setEnabled(b);
        this.gamemenuButton.setEnabled(b);
        this.supplyButton.setEnabled(b);
    }

    protected void updateGUI() {
        this.tothingField.setText(this.runner.getPlayerData().getMilesLeftTillNextMilestone() + " miles");
        this.nextThingLabel.setText(this.runner.getPlayerData().getNextMilestone().getName());
        this.toendField.setText(this.runner.getPlayerData().getTrailPos() + " miles");
        this.healthField.setText(this.runner.getPlayerData().getPHealth() + "");
        this.health1Field.setText(this.runner.getPlayerData().getPMember(0).getHealth());
        this.health2Field.setText(this.runner.getPlayerData().getPMember(1).getHealth());
        this.health3Field.setText(this.runner.getPlayerData().getPMember(2).getHealth());
        this.health4Field.setText(this.runner.getPlayerData().getPMember(3).getHealth());
        this.name1Label.setText(this.runner.getPlayerData().getPMember(0).getName() + ":");
        this.name2Label.setText(this.runner.getPlayerData().getPMember(1).getName() + ":");
        this.name3Label.setText(this.runner.getPlayerData().getPMember(2).getName() + ":");
        this.name4Label.setText(this.runner.getPlayerData().getPMember(3).getName() + ":");
        this.dateField.setText(this.runner.getDynamicData().getDateString() + "");
        this.daysField.setText(this.runner.getDynamicData().getTrailDays() + "");
        this.typeLabel.setText(this.runner.getPlayerData().getPlayerType());
        this.repaint();
    }

    private JPanel leftPanel() {
        JPanel lp = new JPanel(new BorderLayout());
        lp.setBorder(BorderFactory.createEtchedBorder(1));
        LogoPanel logoPanel = new LogoPanel("/gamedata/" + this.runner.getStaticData().getGameType() + "/img/logo.png");
        logoPanel.setPreferredSize(new Dimension(225, 150));
        lp.add((Component)logoPanel, "North");
        lp.add((Component)this.statusPanel(), "Center");
        lp.add((Component)this.timePanel(), "South");
        return lp;
    }

    private JPanel statusPanel() {
        JPanel sp = new JPanel(new GridLayout(15, 0));
        sp.setBorder(BorderFactory.createTitledBorder("Player Status"));
        JPanel namePanel = new JPanel(new GridLayout(0, 2));
        namePanel.add(new JLabel("Player Name:"));
        namePanel.add(new JLabel(this.runner.getPlayerName()));
        sp.add(namePanel);
        JPanel typePanel = new JPanel(new GridLayout(0, 2));
        typePanel.add(new JLabel("Player type:"));
        this.typeLabel = new JLabel("");
        typePanel.add(this.typeLabel);
        sp.add(typePanel);
        JPanel healthPanel = new JPanel(new GridLayout(0, 2));
        healthPanel.add(new JLabel("Health:"));
        this.healthField = new JTextField();
        this.healthField.setEditable(false);
        healthPanel.add(this.healthField);
        sp.add(healthPanel);
        JPanel health1Panel = new JPanel(new GridLayout(0, 2));
        this.name1Label = new JLabel();
        health1Panel.add(this.name1Label);
        this.health1Field = new JTextField();
        this.health1Field.setEditable(false);
        health1Panel.add(this.health1Field);
        sp.add(health1Panel);
        JPanel health2Panel = new JPanel(new GridLayout(0, 2));
        this.name2Label = new JLabel();
        health2Panel.add(this.name2Label);
        this.health2Field = new JTextField();
        this.health2Field.setEditable(false);
        health2Panel.add(this.health2Field);
        sp.add(health2Panel);
        JPanel health3Panel = new JPanel(new GridLayout(0, 2));
        this.name3Label = new JLabel();
        health3Panel.add(this.name3Label);
        this.health3Field = new JTextField();
        this.health3Field.setEditable(false);
        health3Panel.add(this.health3Field);
        sp.add(health3Panel);
        JPanel health4Panel = new JPanel(new GridLayout(0, 2));
        this.name4Label = new JLabel();
        health4Panel.add(this.name4Label);
        this.health4Field = new JTextField();
        this.health4Field.setEditable(false);
        health4Panel.add(this.health4Field);
        sp.add(health4Panel);
        JPanel rationsPanel = new JPanel(new GridLayout(0, 2));
        rationsPanel.add(new JLabel("Rations:"));
        this.rationsCombo = new JComboBox<String>(this.rations);
        for (int i = 0; i < this.rations.length; ++i) {
            if (!this.rations[i].equals(this.runner.getPlayerData().getPRations())) continue;
            this.rationsCombo.setSelectedIndex(i);
            break;
        }
        this.rationsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                GameGUI.this.runner.setRations((String)cb.getSelectedItem());
            }
        });
        rationsPanel.add(this.rationsCombo);
        sp.add(rationsPanel);
        JPanel speedPanel = new JPanel(new GridLayout(0, 2));
        speedPanel.add(new JLabel("Speed:"));
        this.speedCombo = new JComboBox<String>(this.speeds);
        for (int i = 0; i < this.speeds.length; ++i) {
            if (!this.speeds[i].equals(this.runner.getPlayerData().getPPace())) continue;
            this.speedCombo.setSelectedIndex(i);
            break;
        }
        this.speedCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                GameGUI.this.runner.setSpeed((String)cb.getSelectedItem());
            }
        });
        speedPanel.add(this.speedCombo);
        sp.add(speedPanel);
        sp.add(new JPanel());
        this.nextThingLabel = new JLabel();
        sp.add(this.nextThingLabel);
        JPanel tothingPanel = new JPanel(new GridLayout(0, 2));
        tothingPanel.add(new JLabel("To Milestone:"));
        this.tothingField = new JTextField();
        this.tothingField.setEditable(false);
        tothingPanel.add(this.tothingField);
        sp.add(tothingPanel);
        JPanel toendPanel = new JPanel(new GridLayout(0, 2));
        toendPanel.add(new JLabel("Miles Traveled:"));
        this.toendField = new JTextField("0 miles");
        this.toendField.setEditable(false);
        toendPanel.add(this.toendField);
        sp.add(toendPanel);
        sp.add(new JPanel());
        this.supplyButton = new JButton("check supplies");
        this.supplyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GameGUI.this.runner.checkSupplies();
            }
        });
        sp.add(this.supplyButton);
        return sp;
    }

    private JPanel timePanel() {
        JPanel tp = new JPanel(new GridLayout(2, 0));
        tp.setBorder(BorderFactory.createEtchedBorder());
        JPanel datePanel = new JPanel(new BorderLayout());
        datePanel.add((Component)new JLabel("Date:"), "West");
        this.dateField = new JTextField("June 17, 1827");
        this.dateField.setEditable(false);
        datePanel.add((Component)this.dateField, "Center");
        tp.add(datePanel);
        JPanel daysPanel = new JPanel(new BorderLayout());
        daysPanel.add((Component)new JLabel("Travel Days:"), "Center");
        this.daysField = new JTextField("19", 5);
        this.daysField.setEditable(false);
        daysPanel.add((Component)this.daysField, "East");
        tp.add(daysPanel);
        return tp;
    }

    private JPanel rightPanel() {
        JPanel rp = new JPanel(new BorderLayout());
        rp.setBorder(BorderFactory.createEtchedBorder(1));
        rp.add((Component)new GraphicsPanel(this.runner), "Center");
        rp.add((Component)this.buttonPanel(), "South");
        return rp;
    }

    private JPanel buttonPanel() {
        JPanel bp = new JPanel(new GridLayout(0, 6));
        this.huntButton = new JButton("hunt");
        this.huntButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GameGUI.this.runner.goShooting();
            }
        });
        bp.add(this.huntButton);
        this.restButton = new JButton("rest");
        this.restButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GameGUI.this.runner.rest();
            }
        });
        bp.add(this.restButton);
        this.tradeButton = new JButton("trade");
        this.tradeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GameGUI.this.runner.trade();
            }
        });
        bp.add(this.tradeButton);
        this.turndoneButton = new JButton("travel on");
        this.turndoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GameGUI.this.runner.endTurn();
            }
        });
        bp.add(this.turndoneButton);
        this.mapButton = new JButton("map");
        this.mapButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GameGUI.this.runner.checkMap();
            }
        });
        bp.add(this.mapButton);
        this.gamemenuButton = new JButton("game...");
        this.gamemenuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                GameGUI.this.runner.gameMenu();
            }
        });
        bp.add(this.gamemenuButton);
        return bp;
    }

    public GameGUI(GameRunner grunner) {
        super(grunner.getStaticData().getGameType());
        this.runner = grunner;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.leftPanel(), "West");
        this.getContentPane().add((Component)this.rightPanel(), "Center");
        this.setSize(800, 500);
    }
}

