/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class Controller
extends WindowController {
    private boolean isSinglePlayer = true;
    private boolean isNewGame = true;
    private boolean isConnecting = false;
    private DefaultListModel userListModel = new DefaultListModel();
    private GameServer gameServer = null;
    private PlayerServer playerServer = null;
    private ONetServer pNetServer;
    private StaticGameData staticData;
    private DynamicData dynamicData;
    private String playerName;
    private ServerConnection sc;

    public DefaultListModel getUserListModel() {
        return this.userListModel;
    }

    public void addPlayer(String name, String ip) {
        this.userListModel.addElement(name + ": " + ip);
    }

    protected void resetData() {
        ThreadGroup currentGroup = Thread.currentThread().getThreadGroup();
        int numThreads = currentGroup.activeCount();
        Thread[] threads = new Thread[numThreads];
        currentGroup.enumerate(threads);
        for (int i = 0; i < numThreads; ++i) {
            if (threads[i] == null || threads[i].getName() == null || !threads[i].getName().equals("gameServerThread")) continue;
            threads[i].interrupt();
            JOptionPane.showMessageDialog(null, "Shutting down engine");
            System.exit(0);
        }
        this.isSinglePlayer = true;
        this.isNewGame = true;
        this.isConnecting = false;
        this.userListModel = new DefaultListModel();
        this.gameServer = null;
        this.pNetServer = null;
        this.staticData = null;
        this.dynamicData = null;
        this.playerName = "";
    }

    protected void reset() {
        this.resetData();
        this.previousGui();
        new StartGUI(new Controller());
        this.destroy();
    }

    protected void newSinglePlayerGame() {
        this.setGui(new ChooseType(this));
    }

    protected void hostNewGame() {
        this.isSinglePlayer = false;
        this.setGui(new ChooseType(this));
    }

    protected void connectToGame() {
        JOptionPane.showMessageDialog(this.getGui(), "You will not be able to joing a game that is already in progress\nand to connect to a game that is being resumed by a server, you \nmust connect with the exact username that you used before.");
        this.isConnecting = true;
        this.setGui(new ConnectGameGUI(this));
    }

    protected void loadSinglePlayerGame() {
        this.isNewGame = false;
        this.loadGameData();
    }

    protected void resumeHostGame() {
        JOptionPane.showMessageDialog(this.getGui(), "All Players from the saved game must connect before you press \nstart or else the game will not allow you to resume playing.");
        this.isNewGame = false;
        this.isSinglePlayer = false;
        this.loadGameData();
    }

    protected void loadGameData() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(this.getGui());
        if (returnVal == 0) {
            GameStartedAction objLoaded;
            File file = fc.getSelectedFile();
            try {
                objLoaded = (GameStartedAction)OUtils.xmlToObj(new FileInputStream(file));
            }
            catch (FileNotFoundException fnfe) {
                Messager.STD.sendError("We can't use that file (" + file + "), try again.", fnfe);
                return;
            }
            catch (Exception e) {
                Messager.STD.sendError("Unable to load game.", e);
                return;
            }
            this.loadData(objLoaded.getStaticGameData(), objLoaded.getDynamicData(), objLoaded.getPlayerName());
        } else {
            this.resetData();
        }
    }

    protected void loadData(StaticGameData sdata, DynamicData ddata, String gPlayerName) {
        this.staticData = sdata;
        this.dynamicData = ddata;
        this.playerName = gPlayerName;
        this.startServer(17432, "");
        this.connectToServer(this.playerName, "localhost", 17432, "");
        if (!this.isSinglePlayer) {
            this.setGui(new HostingGUI(this));
        } else {
            this.startHosting();
        }
    }

    protected void chooseTypeReturn(String nGameType, int nStartMonth) {
        this.staticData = new StaticGameData(nGameType);
        this.dynamicData = new DynamicData();
        this.dynamicData.setGameDate(new GregorianCalendar(1843, nStartMonth, 1));
        this.previousGui();
        this.setGui(new ChooseNameGUI(this));
    }

    protected void chooseNameGUIReturn(String nPlayerName) {
        this.playerName = nPlayerName;
        this.previousGui();
        if (this.isSinglePlayer) {
            this.startServer(17432, "");
            this.connectToServer(nPlayerName, "localhost", 17432, "");
            this.startHosting();
        } else {
            this.setGui(new HostGameGUI(this));
        }
    }

    protected void connectGameGUIReturn(String gplayerName, String gameServerHostName, int gameServerPortNum, String gamePassword) {
        this.previousGui();
        this.connectToServer(gplayerName, gameServerHostName, gameServerPortNum, gamePassword);
        this.getGui().setVisible(false);
        this.setGui(new WaitingGUI());
    }

    protected void hostGameGUIReturn(int gameServerPortNum, String gamePassword) {
        this.previousGui();
        this.startServer(gameServerPortNum, gamePassword);
        this.connectToServer(this.playerName, "localhost", gameServerPortNum, gamePassword);
        this.setGui(new HostingGUI(this));
    }

    protected void startServer(int gameServerPortNum, String gamePassword) {
        ONetServer gNetServer;
        this.gameServer = new GameServer(this);
        try {
            gNetServer = new ONetServer(gameServerPortNum, this.gameServer);
        }
        catch (IOException e) {
            Messager.STD.sendError("Unable to start hosting. Maybe youneed to try a different port?", e);
            this.reset();
            return;
        }
        new Thread((Runnable)gNetServer, "gameServerThread").start();
    }

    protected void connectToServer(String userName, String gameServerAddress, int gameServerPortNum, String gamePassword) {
        ONetClient oNetClient;
        this.playerName = userName;
        if (null == this.pNetServer) {
            this.playerServer = new PlayerServer(this);
            try {
                this.pNetServer = new ONetServer(this.playerServer);
            }
            catch (IOException e) {
                Messager.STD.sendError("Unable to start Player'sServerSocket.", e);
                this.reset();
                return;
            }
            new Thread((Runnable)this.pNetServer, "playerSocketThread").start();
        }
        this.sc = new ServerConnection(userName, gameServerAddress, gameServerPortNum, this.pNetServer.getPort());
        try {
            oNetClient = new ONetClient(this.sc);
        }
        catch (UnknownHostException e) {
            Messager.STD.sendError("Server Name \"" + gameServerAddress + "\" unknown.", e);
            this.reset();
            return;
        }
        this.sc.setONetClient(oNetClient);
        try {
            this.sc.sendRequest(new PlayGameAction(this.sc));
        }
        catch (Exception e) {
            Messager.STD.sendError("Unable to start playing the game.", e);
            this.reset();
            return;
        }
    }

    protected void startGame() {
        if (this.isNewGame) {
            this.dynamicData.getStatList().put(this.playerName, new PlayerStats(this.staticData));
            ((PlayerStats)this.dynamicData.getStatList().get(this.playerName)).getLeader().setName(this.playerName);
        }
        GameRunner runner = new GameRunner(this.playerName, this.staticData, this.dynamicData, this.sc);
        this.playerServer.setGameRunner(runner);
        this.destroy();
    }

    protected void serverSendStart(StaticGameData sdata, DynamicData ddata) {
        if (this.isConnecting) {
            this.previousGui();
        }
        this.staticData = sdata;
        this.dynamicData = ddata;
        this.startGame();
    }

    protected void startHosting() {
        this.gameServer.startGame(this.staticData, this.dynamicData);
    }
}

