/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ChooseType
extends JFrame {
    private String[] gameNames = new String[]{"oregon_trail"};
    private String[] startMonths = new String[]{"March", "April", "May", "June", "July", "August"};
    private int startMonth;
    private String gameName;
    private Controller controller;

    public void setGameName(String nname) {
        this.gameName = nname;
    }

    public void setStartMonth(int nmonth) {
        this.startMonth = nmonth;
    }

    protected final void readGameNames() {
        File datafolder = new File(this.getClass().getResource("/gamedata/").getFile());
        Vector<String> l = new Vector<String>();
        if (datafolder.listFiles() != null) {
            File[] datafiles = datafolder.listFiles();
            for (int i = 0; i < datafiles.length; ++i) {
                if (!datafiles[i].isDirectory()) continue;
                l.add(datafiles[i].getName());
            }
        } else {
            try {
                ZipFile datafile = new ZipFile("trailblazer.jar");
                Enumeration<? extends ZipEntry> e = datafile.entries();
                while (e.hasMoreElements()) {
                    String beg;
                    ZipEntry ze = e.nextElement();
                    if (!ze.isDirectory() || !ze.getName().startsWith("gamedata/") || (beg = ze.getName().substring(9)).length() == 0 || beg.indexOf("/") != beg.length() - 1) continue;
                    l.add(beg.substring(0, beg.indexOf("/")));
                }
            }
            catch (Exception e) {
                return;
            }
        }
        this.gameNames = l.toArray(this.gameNames);
    }

    private JPanel middlePanel() {
        JPanel mp = new JPanel(new GridLayout(0, 2));
        mp.add(new JLabel("start month:"));
        JComboBox<String> monthList = new JComboBox<String>(this.startMonths);
        monthList.setSelectedIndex(0);
        this.startMonth = monthList.getSelectedIndex();
        monthList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                ChooseType ct = (ChooseType)((JComboBox)e.getSource()).getTopLevelAncestor();
                ct.setStartMonth(cb.getSelectedIndex());
            }
        });
        mp.add(monthList);
        return mp;
    }

    private JPanel bottomPanel() {
        JPanel bp = new JPanel(new GridLayout(0, 2));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChooseType.this.controller.reset();
            }
        });
        bp.add(cancelButton);
        JButton playButton = new JButton("OK");
        playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChooseType.this.controller.chooseTypeReturn(ChooseType.this.gameName, ChooseType.this.startMonth + 3);
            }
        });
        bp.add(playButton);
        return bp;
    }

    public ChooseType(Controller c) {
        super("Choose Game Type");
        this.controller = c;
        this.getContentPane().setLayout(new GridLayout(4, 0));
        this.readGameNames();
        JLabel mainLabel = new JLabel("Choose Game", 0);
        this.getContentPane().add(mainLabel);
        JComboBox<String> gameList = new JComboBox<String>(this.gameNames);
        for (int i = 0; i < this.gameNames.length; ++i) {
            if (!this.gameNames[i].equals("oregon_trail")) continue;
            gameList.setSelectedIndex(i);
            break;
        }
        this.gameName = (String)gameList.getSelectedItem();
        gameList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                ChooseType ct = (ChooseType)((JComboBox)e.getSource()).getTopLevelAncestor();
                ct.setGameName((String)cb.getSelectedItem());
            }
        });
        this.getContentPane().add(gameList);
        this.getContentPane().add(this.middlePanel());
        this.getContentPane().add(this.bottomPanel());
        this.setSize(200, 100);
        JOptionPane.showMessageDialog(this, "Leave too early and there won't be enough \n resources on the trail to keep you going. \nLeave too late and you won't be able to make \nit before winter.");
    }

    public static void main(String[] args) {
        new ChooseType(new Controller());
    }
}

