/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.swing.JOptionPane;

public class BreakdownEvent
extends RandomEvent {
    private double testing = -1.0;
    private int testpart = -1;
    private double currentProbability;

    public void repair(char toRepair, PlayerStats who) {
        Random decision = new Random();
        if (decision.nextDouble() < 0.5) {
            JOptionPane.showMessageDialog(null, "Repair failed.");
            this.replace(toRepair, who);
        } else {
            JOptionPane.showMessageDialog(null, "Repair was successful");
        }
    }

    public void replace(char toReplace, PlayerStats who) {
        switch (toReplace) {
            case '\u0000': {
                if (who.getPPart1() > 0) {
                    who.setPPart1(who.getPPart1() - 1);
                    JOptionPane.showMessageDialog(null, "Replaced wheel.");
                    break;
                }
                who.setStuck(true);
                JOptionPane.showMessageDialog(null, "You don't have any spare wheels.  You're stuck!");
                break;
            }
            case '\u0001': {
                if (who.getPPart2() > 0) {
                    who.setPPart2(who.getPPart2() - 1);
                    JOptionPane.showMessageDialog(null, "Replaced axle.");
                    break;
                }
                who.setStuck(true);
                JOptionPane.showMessageDialog(null, "You don't have any spare axles.  You're stuck!");
                break;
            }
            case '\u0002': {
                if (who.getPPart3() > 0) {
                    who.setPPart3(who.getPPart3() - 1);
                    JOptionPane.showMessageDialog(null, "Replaced wagon tongue.");
                    break;
                }
                who.setStuck(true);
                JOptionPane.showMessageDialog(null, "You don't have any spare wagon tongues.  You're stuck!");
                break;
            }
            default: {
                System.out.println("In BreakdownEvent, replace not working");
            }
        }
    }

    public void run(PlayerStats toBreak) {
        Random decision = new Random();
        Object[] options = new Object[]{"Yes", "No"};
        this.currentProbability = this.getStartProb();
        if (decision.nextDouble() < this.currentProbability && this.testing < this.currentProbability) {
            char part = (char)decision.nextInt(3);
            if (this.testpart != -1) {
                part = (char)this.testpart;
            }
            switch (part) {
                case '\u0000': {
                    int choice = JOptionPane.showOptionDialog(null, "A wheel has broken.\n Attempt to repair it?\n", "Breakdown", 0, 3, null, options, options[0]);
                    if (choice == 0) {
                        this.repair(part, toBreak);
                        break;
                    }
                    this.replace(part, toBreak);
                    break;
                }
                case '\u0001': {
                    int choice = JOptionPane.showOptionDialog(null, "An axle has broken.\n Attempt to repair it?\n", "Breakdown", 0, 3, null, options, options[0]);
                    if (choice == 0) {
                        this.repair(part, toBreak);
                        break;
                    }
                    this.replace(part, toBreak);
                    break;
                }
                case '\u0002': {
                    int choice = JOptionPane.showOptionDialog(null, "A wagon tongue has broken.\n Attempt to repair it?\n", "Breakdown", 0, 3, null, options, options[0]);
                    if (choice == 0) {
                        this.repair(part, toBreak);
                        break;
                    }
                    this.replace(part, toBreak);
                    break;
                }
                default: {
                    System.out.println("BreakdownEvent run not working");
                }
            }
        }
    }

    public BreakdownEvent(String message, double prob) {
        super(message, prob);
    }
}

