/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class BigMapLabel
extends JLabel {
    private Rectangle drawWithin;
    private double minLat;
    private double maxLat;
    private double minLong;
    private double maxLong;
    private Milestone startMilestone;
    private GameRunner runner;

    public BigMapLabel(GameRunner runnerParam) {
        this.runner = runnerParam;
        String urlPrefix = "/gamedata/" + this.runner.getStaticData().getGameType();
        Class<?> c = this.getClass();
        URL mapURL = c.getResource(urlPrefix + "/img/map.png");
        URL mapdataURL = c.getResource(urlPrefix + "/map.xml");
        URL milestoneURL = c.getResource(urlPrefix + "/trailstops.xml");
        this.setIcon(new ImageIcon(mapURL));
        try {
            BigMapData md = (BigMapData)OUtils.xmlToObj(mapdataURL.openStream());
            this.drawWithin = md.getDrawWithin();
            this.minLat = md.getMinLat();
            this.maxLat = md.getMaxLat();
            this.minLong = md.getMinLong();
            this.maxLong = md.getMaxLong();
        }
        catch (Exception e) {
            Messager.STD.sendError("Can't open map data xml file", e);
        }
        try {
            this.startMilestone = (Milestone)OUtils.xmlToObj(milestoneURL.openStream());
        }
        catch (Exception e) {
            Messager.STD.sendError("Can't open map data xml file", e);
        }
    }

    public Point getMilestoneImageCoords(Milestone m) {
        if (null == m) {
            return null;
        }
        double latPercent = (this.maxLat - m.getLat()) / (this.maxLat - this.minLat);
        double longPercent = (this.maxLong - m.getLong()) / (this.maxLong - this.minLong);
        int x = this.drawWithin.x + (int)(longPercent * (double)this.drawWithin.width);
        int y = this.drawWithin.y + (int)(latPercent * (double)this.drawWithin.height);
        return new Point(x, y);
    }

    public void paintMilestone(Graphics g, Milestone m) {
        if (null == m) {
            return;
        }
        Point p = this.getMilestoneImageCoords(m);
        int x = p.x;
        int y = p.y;
        int radius = 5;
        g.setColor(Color.BLACK);
        g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
        Graphics2D g2d = (Graphics2D)g;
        Point2D loc = new Point2D.Float(x - radius * 2 - 3, y + radius);
        TextLayout layout = new TextLayout(m.getName(), g.getFont(), g2d.getFontRenderContext());
        int cellspacing = 2;
        Rectangle2D bounds = layout.getBounds();
        loc = new Point2D.Double(loc.getX() - bounds.getWidth(), loc.getY() + bounds.getHeight());
        bounds.setRect(bounds.getX() + loc.getX() - (double)cellspacing, bounds.getY() + loc.getY() - (double)cellspacing, bounds.getWidth() + (double)(2 * cellspacing), bounds.getHeight() + (double)(2 * cellspacing));
        g.setColor(Color.WHITE);
        g2d.fill(bounds);
        g.setColor(Color.BLACK);
        layout.draw(g2d, (float)loc.getX(), (float)loc.getY());
        NextMilestoneData[] next = m.getNextMilestones();
        if (null == next) {
            return;
        }
        for (int i = 0; i < next.length; ++i) {
            this.paintMilestone(g, next[i].getMilestone());
        }
    }

    public Point getPlayerImageCoords(PlayerStats ps, Graphics g) {
        Milestone lastM = ps.getLastMilestone();
        Milestone nextM = ps.getNextMilestone();
        Point lastP = this.getMilestoneImageCoords(lastM);
        Point nextP = this.getMilestoneImageCoords(nextM);
        if (0 == ps.getMilesInbetween()) {
            return nextP;
        }
        if (0 == ps.getMilesLeftTillNextMilestone()) {
            return nextP;
        }
        g.setColor(Color.BLACK);
        g.drawLine(lastP.x, lastP.y, nextP.x, nextP.y);
        int xDelta = nextP.x - lastP.x;
        int yDelta = nextP.y - lastP.y;
        double percentDone = (double)(ps.getMilesInbetween() - ps.getMilesLeftTillNextMilestone()) / (double)ps.getMilesInbetween();
        int xAdd = (int)((double)xDelta * percentDone);
        int yAdd = (int)((double)yDelta * percentDone);
        return new Point(lastP.x + xAdd, lastP.y + yAdd);
    }

    public void paintPlayer(Graphics g, PlayerStats ps) {
        if (null == ps) {
            return;
        }
        Point p = this.getPlayerImageCoords(ps, g);
        int x = p.x;
        int y = p.y;
        int radius = 5;
        g.setColor(Color.RED);
        g.fillRect(x - radius, y - radius, radius * 2, radius * 2);
        Graphics2D g2d = (Graphics2D)g;
        Point2D.Float loc = new Point2D.Float(x + radius * 2 + 3, y - radius);
        TextLayout layout = new TextLayout(ps.getLeader().getName(), g.getFont(), g2d.getFontRenderContext());
        int cellspacing = 2;
        Rectangle2D bounds = layout.getBounds();
        bounds.setRect(bounds.getX() + ((Point2D)loc).getX() - (double)cellspacing, bounds.getY() + ((Point2D)loc).getY() - (double)cellspacing, bounds.getWidth() + (double)(2 * cellspacing), bounds.getHeight() + (double)(2 * cellspacing));
        g.setColor(Color.LIGHT_GRAY);
        g2d.fill(bounds);
        g.setColor(Color.RED);
        layout.draw(g2d, (float)((Point2D)loc).getX(), (float)((Point2D)loc).getY());
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintMilestone(g, this.startMilestone);
        PlayerStats[] allPlayers = this.runner.getDynamicData().getStatList().values().toArray(new PlayerStats[0]);
        for (int i = 0; i < allPlayers.length; ++i) {
            this.paintPlayer(g, allPlayers[i]);
        }
    }
}

